"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.AllowanceProvider = void 0;
const tslib_1 = require("tslib");
const Permit2_json_1 = tslib_1.__importDefault(require("../../abis/Permit2.json"));
const contracts_1 = require("@ethersproject/contracts");
class AllowanceProvider {
    constructor(provider, permit2Address) {
        this.provider = provider;
        this.permit2Address = permit2Address;
        this.permit2 = new contracts_1.Contract(this.permit2Address, Permit2_json_1.default, this.provider);
    }
    getAllowanceData(token, owner, spender) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return yield this.permit2.allowance(owner, token, spender);
        });
    }
    getAllowance(token, owner, spender) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return (yield this.getAllowanceData(token, owner, spender)).amount;
        });
    }
    getNonce(token, owner, spender) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return (yield this.getAllowanceData(token, owner, spender)).nonce;
        });
    }
    getExpiration(token, owner, spender) {
        return tslib_1.__awaiter(this, void 0, void 0, function* () {
            return (yield this.getAllowanceData(token, owner, spender)).expiration;
        });
    }
}
exports.AllowanceProvider = AllowanceProvider;
//# sourceMappingURL=AllowanceProvider.js.map